/*
 * Decompiled with CFR 0.152.
 */
package tw.com.prolific.pl2303multilib;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.util.Log;
import android.widget.Toast;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import tw.com.prolific.pl2303multilib.UsbDeviceInfo;

public class PL2303MultiLib {
    private static final boolean b = false;
    private static final boolean c = false;
    private static final boolean d = false;
    private static String e = "0.0.1.26";
    public static final int BAUD0 = 0;
    public static final int BAUD75 = 75;
    public static final int BAUD150 = 150;
    public static final int BAUD300 = 300;
    public static final int BAUD600 = 600;
    public static final int BAUD1200 = 1200;
    public static final int BAUD1800 = 1800;
    public static final int BAUD2400 = 2400;
    public static final int BAUD4800 = 4800;
    public static final int BAUD9600 = 9600;
    public static final int BAUD14400 = 14400;
    public static final int BAUD19200 = 19200;
    public static final int BAUD38400 = 38400;
    public static final int BAUD57600 = 57600;
    public static final int BAUD115200 = 115200;
    public static final int BAUD230400 = 230400;
    public static final int BAUD460800 = 460800;
    public static final int BAUD614400 = 614400;
    public static final int BAUD921600 = 921600;
    public static final int BAUD1228800 = 1228800;
    public static final int BAUD2457600 = 2457600;
    public static final int BAUD3000000 = 3000000;
    public static final int BAUD6000000 = 6000000;
    private final int f = 2;
    private final int g = 3;
    private final int h = 4;
    private final int i = 5;
    private final int j = 6;
    private final int k = 7;
    private final int l = 8;
    private final int m = 9;
    private final int n = 4;
    private final int o = 5;
    public static final int PL2303HXD_DCD_ON = 1;
    public static final int PL2303HXD_DSR_ON = 2;
    public static final int PL2303HXD_RI_ON = 8;
    public static final int PL2303HXD_CTS_ON = 128;
    private static final int p = 33;
    private static final int q = 32;
    private static final int r = 33;
    private static final int s = 35;
    private static final int t = 0;
    private static final int u = 161;
    private static final int v = 33;
    private static final int w = 64;
    private static final int x = 1;
    private static final int y = 192;
    private static final int z = 1;
    private static final int A = 33;
    private static final int B = 34;
    private static final int C = 0;
    private static final int D = 1;
    private static final int E = 2;
    private static final int F = 2056;
    private static final int G = 2313;
    private final boolean H = true;
    private final boolean I = false;
    private final int J = 17;
    private final int K = 19;
    private static final int L = 1;
    private static final int M = 2;
    private byte[] N = new byte[7];
    private int O;
    private int P;
    private int Q;
    private static final int R = 4096;
    private static final int S = 1228800;
    private static final String T = "PL2303MultiLib";
    private UsbManager U;
    private String V;
    private ArrayList<String> W = new ArrayList();
    private int X;
    Context a;
    private static final int Y = 10;
    private static final String Z = null;
    private boolean[] aa = new boolean[10];
    private boolean[] ab = new boolean[10];
    private UsbDeviceInfo[] ac;
    private int ad;
    public String PLUART_MESSAGE = "tw.PL2303MultiUSBMessage";
    public String PLUART_DETACHED = "MultiUSB.Detached";
    public Hashtable<String, UsbDevice> ProlificUSBCurrentDeviceList;
    public Hashtable<String, String> Prolific_DevicePath_2_COMNumber;
    private boolean ae;
    private a[] af;
    private boolean[] ag = new boolean[10];
    private final BroadcastReceiver ah = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            UsbDevice usbDevice = (UsbDevice)intent.getParcelableExtra("device");
            if (!"android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(string)) {
                if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(string)) {
                    String string2 = usbDevice.getDeviceName();
                    int n = PL2303MultiLib.this.a(usbDevice);
                    if (n >= 0) {
                        if (PL2303MultiLib.this.ac[n].e().equals(string2)) {
                            PL2303MultiLib.this.e(usbDevice);
                            UsbDevice usbDevice2 = PL2303MultiLib.this.ProlificUSBCurrentDeviceList.remove(usbDevice.getDeviceName());
                            Intent intent2 = new Intent(PL2303MultiLib.this.PLUART_MESSAGE);
                            intent2.putExtra(PL2303MultiLib.this.PLUART_DETACHED, String.valueOf(n));
                            PL2303MultiLib.this.a.sendBroadcast(intent2);
                        }
                        if (PL2303MultiLib.this.ad == 0) {
                            PL2303MultiLib.this.a.unregisterReceiver(PL2303MultiLib.this.ah);
                        }
                    }
                    Toast.makeText((Context)PL2303MultiLib.this.a, (CharSequence)(String.valueOf(string2) + " disconnected"), (int)0).show();
                } else if (string.equals(PL2303MultiLib.this.V)) {
                    1 var5_6 = this;
                    synchronized (var5_6) {
                        if (intent.getBooleanExtra("permission", false) && usbDevice != null) {
                            int n = 0;
                            while (n < PL2303MultiLib.this.X) {
                                if (String.format("%04X:%04X", usbDevice.getVendorId(), usbDevice.getProductId()).equals(PL2303MultiLib.this.W.get(n))) {
                                    PL2303MultiLib.this.b(usbDevice);
                                    return;
                                }
                                ++n;
                            }
                        }
                    }
                }
            }
        }
    };
    private static UsbDevice ai = null;
    private Runnable aj = new Runnable(){

        @Override
        public void run() {
            UsbDevice usbDevice = ai;
            if (usbDevice == null) {
                return;
            }
            if (!PL2303MultiLib.this.d(usbDevice)) {
                PL2303MultiLib.this.c(usbDevice);
                return;
            }
        }
    };
    private static /* synthetic */ int[] ak;
    private static /* synthetic */ int[] al;
    private static /* synthetic */ int[] am;
    private static /* synthetic */ int[] an;
    private static /* synthetic */ int[] ao;

    private void a(UsbManager usbManager, Context context, String string, boolean bl) {
        this.U = usbManager;
        this.a = context;
        this.V = string;
        this.W.add("067B:2303");
        this.W.add("067B:2551");
        this.W.add("067B:2503");
        this.W.add("067B:AAA5");
        this.W.add("05AD:0FBA");
        this.a("067B:2304");
        this.X = this.W.size();
        this.ac = new UsbDeviceInfo[10];
        this.af = new a[10];
        this.ProlificUSBCurrentDeviceList = new Hashtable();
        this.Prolific_DevicePath_2_COMNumber = new Hashtable();
        this.ae = false;
        int n = 0;
        while (n < 10) {
            this.aa[n] = false;
            this.ab[n] = false;
            this.ac[n] = new UsbDeviceInfo();
            this.af[n] = new a();
            this.ag[n] = bl;
            ++n;
        }
        this.ad = 0;
        this.O = 100;
        this.P = 100;
        this.Q = 100;
    }

    public PL2303MultiLib(UsbManager manager, Context context, String sAppName) {
        this.a(manager, context, sAppName, true);
    }

    public PL2303MultiLib(UsbManager manager, Context context, String sAppName, boolean bWithQueue) {
        this.a(manager, context, sAppName, bWithQueue);
    }

    public void PL2303Release() {
        if (this.ad != 0) {
            int n = 0;
            while (n < 10) {
                if (this.ag[n] && this.af[n].d) {
                    this.b(this.af[n]);
                }
                this.ac[n].a();
                this.aa[n] = false;
                this.ab[n] = false;
                this.ag[n] = false;
                ++n;
            }
            this.a.unregisterReceiver(this.ah);
            this.W.clear();
            this.ad = 0;
        }
    }

    public void release() {
        this.PL2303Release();
    }

    private void a(String string) {
        this.W.add(string);
        this.X = this.W.size();
    }

    public boolean PL2303USBFeatureSupported() {
        boolean bl = this.a.getPackageManager().hasSystemFeature("android.hardware.usb.host");
        return bl;
    }

    public int PL2303LibGetVersion(byte[] byVersion) {
        int n = 0;
        n = byVersion.length < e.length() ? byVersion.length : e.length();
        char[] cArray = e.toCharArray();
        int n2 = 0;
        while (n2 < n) {
            byVersion[n2] = (byte)cArray[n2];
            ++n2;
        }
        return 0;
    }

    public void PL2303HXD_ReSetStatus() {
        if (this.ad >= 1) {
            Enumeration<UsbDevice> enumeration = this.ProlificUSBCurrentDeviceList.elements();
            while (enumeration.hasMoreElements()) {
                UsbDevice usbDevice = enumeration.nextElement();
                String string = usbDevice.getDeviceName();
                if (this.b(string)) continue;
                this.e(usbDevice);
                int n = this.a(usbDevice);
                UsbDevice usbDevice2 = this.ProlificUSBCurrentDeviceList.remove(string);
                Intent intent = new Intent(this.PLUART_MESSAGE);
                intent.putExtra(this.PLUART_DETACHED, String.valueOf(n));
                this.a.sendBroadcast(intent);
            }
        }
    }

    public int PL2303Enumerate() {
        int n = 0;
        this.U = (UsbManager)this.a.getSystemService("usb");
        HashMap hashMap = this.U.getDeviceList();
        Iterator iterator = hashMap.values().iterator();
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.a, (int)0, (Intent)new Intent(this.V), (int)0);
        while (iterator.hasNext()) {
            UsbDevice usbDevice = (UsbDevice)iterator.next();
            int n2 = 0;
            while (n2 < this.X) {
                if (String.format("%04X:%04X", usbDevice.getVendorId(), usbDevice.getProductId()).equals(this.W.get(n2)) && this.b(usbDevice.getDeviceName())) {
                    IntentFilter intentFilter = new IntentFilter(this.V);
                    intentFilter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
                    this.a.registerReceiver(this.ah, intentFilter);
                    if (!this.U.hasPermission(usbDevice)) {
                        this.U.requestPermission(usbDevice, pendingIntent);
                    } else if (this.ad <= 10) {
                        ++n;
                        this.b(usbDevice);
                    }
                }
                ++n2;
            }
        }
        if (n == 0) {
            // empty if block
        }
        return n;
    }

    public int enumerate() {
        return this.PL2303Enumerate();
    }

    private int a(UsbDevice usbDevice) {
        if (this.ad == 0) {
            return -1;
        }
        int n = 0;
        while (n < 10) {
            UsbDevice usbDevice2;
            if (this.aa[n] && (usbDevice2 = this.ac[n].b()).equals((Object)usbDevice)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private boolean b(String string) {
        String string2 = "";
        boolean bl = true;
        if (Build.VERSION.SDK_INT >= 21) {
            return true;
        }
        try {
            String string3 = "toolbox ls " + string;
            Process process = Runtime.getRuntime().exec(string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                string2 = String.valueOf(string2) + string4;
            }
            if (string.compareTo(string2) != 0) {
                bl = false;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private void b(UsbDevice usbDevice) {
        if (usbDevice == null) {
            return;
        }
        if (!this.d(usbDevice)) {
            this.c(usbDevice);
            return;
        }
    }

    private boolean a(UsbDeviceInfo usbDeviceInfo, UsbInterface usbInterface) {
        if (usbInterface == null) {
            return false;
        }
        int n = 0;
        while (n < usbInterface.getEndpointCount()) {
            if (usbInterface.getEndpoint(n).getType() == 2) {
                if (usbInterface.getEndpoint(n).getDirection() == 128) {
                    usbDeviceInfo.a(usbInterface.getEndpoint(n), true);
                } else {
                    usbDeviceInfo.a(usbInterface.getEndpoint(n), false);
                }
            } else if (usbInterface.getEndpoint(n).getType() == 3 && usbInterface.getEndpoint(n).getDirection() == 128) {
                usbDeviceInfo.a(usbInterface.getEndpoint(n));
            }
            ++n;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c(UsbDevice usbDevice) {
        UsbDeviceConnection usbDeviceConnection;
        Object object;
        int n = 0;
        UsbDeviceInfo usbDeviceInfo = new UsbDeviceInfo();
        if (usbDevice == null) {
            return;
        }
        if (usbDevice.getInterfaceCount() == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < usbDevice.getInterfaceCount()) {
            object = usbDevice.getInterface(n2);
            if (255 == object.getInterfaceClass() && object.getInterfaceProtocol() == 0 && object.getInterfaceSubclass() == 0) {
                n = n2;
                break;
            }
            ++n2;
        }
        UsbInterface usbInterface = usbDevice.getInterface(n);
        int n3 = 0;
        if (usbDevice != null && usbInterface != null && (usbDeviceConnection = this.U.openDevice(usbDevice)) != null) {
            if (usbDeviceConnection.claimInterface(usbInterface, true)) {
                if (this.a(usbDeviceInfo, usbInterface)) {
                    n3 = 0;
                    while (n3 < 10) {
                        if (!this.aa[n3]) break;
                        ++n3;
                    }
                    if (n3 < 10) {
                        object = String.format("%04X:%04X", usbDevice.getVendorId(), usbDevice.getProductId());
                        if (((String)object).equals("067B:2551") || ((String)object).equals("067B:2503")) {
                            usbDeviceInfo.a((String)object, true);
                        } else {
                            usbDeviceInfo.a((String)object, false);
                        }
                        usbDeviceInfo.a(usbDevice.getDeviceName());
                        usbDeviceInfo.a(usbDevice, usbDeviceConnection, usbInterface);
                        PL2303MultiLib pL2303MultiLib = this;
                        synchronized (pL2303MultiLib) {
                            this.ac[n3] = usbDeviceInfo;
                            this.aa[n3] = true;
                            this.ab[n3] = false;
                            ++this.ad;
                            this.ProlificUSBCurrentDeviceList.put(usbDevice.getDeviceName(), usbDevice);
                            if (this.ae) {
                                String string = this.a(usbDevice.getDeviceName(), n3);
                                if (string != Z) {
                                    usbDeviceInfo.b(string);
                                    this.Prolific_DevicePath_2_COMNumber.put(usbDevice.getDeviceName(), string);
                                } else {
                                    usbDeviceInfo.b("");
                                    this.Prolific_DevicePath_2_COMNumber.put(usbDevice.getDeviceName(), "");
                                }
                            }
                        }
                    }
                    return;
                }
            } else {
                usbDeviceConnection.close();
            }
        }
    }

    private boolean d(UsbDevice usbDevice) {
        int n;
        if (this.ad > 0 && (n = this.a(usbDevice)) >= 0) {
            return this.ac[n].o();
        }
        return false;
    }

    private void e(UsbDevice usbDevice) {
        int n;
        if (this.ad > 0 && (n = this.a(usbDevice)) >= 0) {
            this.a(n);
        }
    }

    public boolean PL2303IsDeviceConnectedByIndex(int index) {
        int[] nArray = new int[2];
        nArray = this.PL2303HXD_Get_GPIO_Value(index, 2);
        if (nArray[0] < 0) {
            // empty if block
        }
        if (this.ad > 0 && 10 > index && index >= 0 && this.aa[index]) {
            return this.ac[index].o();
        }
        return false;
    }

    public boolean isDeviceConnectedByIndex(int index) {
        return this.PL2303IsDeviceConnectedByIndex(index);
    }

    private void a(int n) {
        if (this.ad > 0 && 10 > n && n >= 0) {
            if (this.ag[n] && this.af[n].d) {
                this.b(this.af[n]);
                this.af[n] = new a();
            }
            this.aa[n] = false;
            this.ab[n] = false;
            this.ac[n].a();
            --this.ad;
        }
    }

    public String PL2303getDevicePathByIndex(int index) {
        if (this.PL2303IsDeviceConnectedByIndex(index) && 10 > index) {
            return this.ac[index].e();
        }
        return new String("");
    }

    public String PL2303getCOMNumber(int index) {
        if (index > 8) {
            return new String("");
        }
        if (this.PL2303IsDeviceConnectedByIndex(index) && 10 > index) {
            return this.ac[index].f();
        }
        return new String("");
    }

    public boolean EnableFixed_COMPort_Mode() {
        this.ae = true;
        return this.ae;
    }

    public String getDevicePathByIndex(int index) {
        return this.PL2303getDevicePathByIndex(index);
    }

    public String PL2303getSerialByIndex(int index) {
        if (this.PL2303IsDeviceConnectedByIndex(index) && 10 > index) {
            return this.ac[index].g().getSerial();
        }
        return new String("");
    }

    public int PL2303getProlificUSBDeviceCount() {
        return this.ad;
    }

    private void a(a a2) {
        if (!a2.d && a2.c != null) {
            a2.c.start();
            a2.d = a2.c.isAlive();
        }
    }

    private void b(a a2) {
        if (a2.d && a2.c != null) {
            a2.c.a();
            a2.d = a2.c.isAlive();
            a2.c = null;
        }
    }

    private void a(a a2, BaudRate baudRate) throws IOException {
        int[] nArray = new int[]{3, 5, 10, 25, 100, 200};
        int n = nArray[3];
        switch (PL2303MultiLib.b()[baudRate.ordinal()]) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n = nArray[0];
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n = nArray[1];
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n = nArray[2];
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n = nArray[3];
                break;
            }
            case 4: 
            case 5: {
                n = nArray[4];
                break;
            }
            case 2: 
            case 3: {
                n = nArray[5];
                break;
            }
            case 1: {
                n = 0;
                break;
            }
            default: {
                return;
            }
        }
        if (a2.c != null) {
            a2.c.a(n);
        }
    }

    public int PL2303Write(int index, byte[] buf) {
        UsbDeviceInfo usbDeviceInfo = null;
        if (this.ad == 0 || index < 0 || buf.length == 0) {
            return -1;
        }
        if (!this.aa[index] && !this.ab[index]) {
            return -1;
        }
        if (index >= 0) {
            usbDeviceInfo = this.ac[index];
        }
        if (usbDeviceInfo == null || usbDeviceInfo.b() == null) {
            return -2;
        }
        if (usbDeviceInfo.n() && !usbDeviceInfo.m()) {
            return 0;
        }
        return this.a(usbDeviceInfo, buf, buf.length);
    }

    public int write(int index, byte[] buf) {
        return this.PL2303Write(index, buf);
    }

    private int a(UsbDeviceInfo usbDeviceInfo, byte[] byArray, int n) {
        int n2 = 0;
        byte[] byArray2 = new byte[4096];
        UsbDeviceConnection usbDeviceConnection = usbDeviceInfo.g();
        UsbEndpoint usbEndpoint = usbDeviceInfo.a(false);
        while (n2 < n) {
            int n3 = 4096;
            if (n2 + n3 > n) {
                n3 = n - n2;
            }
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            int n4 = usbDeviceConnection.bulkTransfer(usbEndpoint, byArray2, n3, this.P);
            if (n4 < 0) {
                return -1;
            }
            n2 += n4;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int PL2303Read(int index, byte[] buf) {
        int n;
        UsbDeviceInfo usbDeviceInfo = null;
        a a2 = null;
        int n2 = buf.length;
        if (this.ad == 0 || index < 0 || n2 == 0) {
            return -1;
        }
        if (n2 > 4096) {
            buf = new byte[4096];
        }
        if (!this.aa[index] && !this.ab[index]) {
            return -1;
        }
        if (index >= 0) {
            usbDeviceInfo = this.ac[index];
        }
        if (usbDeviceInfo == null || usbDeviceInfo.b() == null) {
            return -2;
        }
        a2 = this.af[index];
        Object object = a2.b;
        synchronized (object) {
            int n3 = a2.a.size();
            if (n3 > 0) {
                n = n2 >= n3 ? n3 : n2;
                int n4 = 0;
                while (n4 < n) {
                    Integer n5 = a2.a.poll();
                    if (n5 != null) {
                        buf[n4] = (byte)(n5 & 0xFF);
                        ++n4;
                        continue;
                    }
                    break;
                }
            } else {
                n = 0;
            }
        }
        return n;
    }

    public int read(int index, byte[] buf) {
        return this.PL2303Read(index, buf);
    }

    private int b(UsbDeviceInfo usbDeviceInfo, byte[] byArray, int n) {
        int n2;
        if (byArray.length == 0 || n == 0) {
            return -1;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 64;
        byte[] byArray2 = new byte[4096];
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        boolean bl2 = false;
        UsbDeviceConnection usbDeviceConnection = usbDeviceInfo.g();
        UsbEndpoint usbEndpoint = usbDeviceInfo.a(true);
        if (n4 > 0 && n <= n4) {
            if (!bl2) {
                System.arraycopy(byArray2, n3, byArray, 0, n);
            } else {
                int n8 = 0;
                while (n8 < n) {
                    byArray[n8] = byArray2[n3++];
                    ++n6;
                    while ((n6 - 1) % 10 != Byte.valueOf(byArray[n8]) - 48) {
                        ++n6;
                    }
                    ++n8;
                }
                n7 += n;
                bl = true;
            }
            n4 -= n;
            return n;
        }
        int n9 = 0;
        int n10 = n;
        if (n4 > 0) {
            n10 -= n4;
            System.arraycopy(byArray2, n3, byArray, n9, n4);
        }
        if ((n2 = usbDeviceConnection.bulkTransfer(usbEndpoint, byArray2, byArray2.length, this.O)) < 0) {
            return n2;
        }
        if (n2 == 0) {
            return 0;
        }
        int n11 = n2 / n5;
        int n12 = n2 % n5;
        if (n12 > 0) {
            ++n11;
        }
        n4 = n2;
        int n13 = 0;
        int n14 = 0;
        while (n14 < n11) {
            int n15 = n14 * n5;
            int n16 = 0;
            while (n16 < n5) {
                byArray2[n13++] = byArray2[n15 + n16];
                ++n16;
            }
            ++n14;
        }
        n3 = 0;
        while (n4 > 0 && n10 > 0) {
            byArray[n9++] = byArray2[n3++];
            if (bl2) {
                ++n6;
                while ((n6 - 1) % 10 != Byte.valueOf(byArray[n9 - 1]) - 48) {
                    ++n6;
                }
            }
            --n4;
            --n10;
        }
        if (bl2) {
            if (n9 > 0) {
                n7 += n9;
                bl = true;
            }
            if (bl) {
                bl = false;
            }
        }
        return n9;
    }

    private boolean b(int n) {
        UsbDeviceInfo usbDeviceInfo = null;
        if (!this.aa[n]) {
            return false;
        }
        usbDeviceInfo = this.ac[n];
        int n2 = this.a(n, usbDeviceInfo);
        if (n2 < 0) {
            return false;
        }
        if (usbDeviceInfo.h() != 4 && usbDeviceInfo.h() != 6) {
            return false;
        }
        if (this.ag[n]) {
            if (this.af[n].c == null) {
                this.af[n].c = new b(n, this.af[n]);
            }
        } else {
            this.af[n].c = null;
        }
        return true;
    }

    public boolean PL2303OpenDevByDefualtSetting(int index) {
        UsbDeviceInfo usbDeviceInfo = null;
        if (this.ad == 0 || index < 0 || this.ad <= index) {
            return false;
        }
        if (!this.aa[index]) {
            return false;
        }
        if (index >= 0) {
            usbDeviceInfo = this.ac[index];
        }
        if (usbDeviceInfo == null || usbDeviceInfo.b() == null) {
            return false;
        }
        if (this.ab[index]) {
            return false;
        }
        this.ab[index] = true;
        if (!this.b(index)) {
            return false;
        }
        if (this.ag[index]) {
            this.a(this.af[index]);
        }
        String string = usbDeviceInfo.b().getDeviceName();
        return true;
    }

    public boolean PL2303OpenDevByBaudRate(int index, BaudRate R) {
        UsbDeviceInfo usbDeviceInfo = null;
        if (this.ad == 0 || index < 0 || this.ad <= index) {
            return false;
        }
        if (index >= 0) {
            usbDeviceInfo = this.ac[index];
        }
        if (usbDeviceInfo == null || usbDeviceInfo.b() == null) {
            return false;
        }
        if (this.ab[index]) {
            return false;
        }
        this.ab[index] = true;
        if (!this.b(index)) {
            return false;
        }
        int n = 0;
        try {
            n = this.a(usbDeviceInfo.g(), index, usbDeviceInfo.h(), R, DataBits.D8, StopBits.S1, Parity.NONE, FlowControl.OFF);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (n < 0) {
            return false;
        }
        usbDeviceInfo.f(false);
        if (this.ag[index]) {
            this.a(this.af[index]);
        }
        String string = usbDeviceInfo.b().getDeviceName();
        return true;
    }

    public boolean PL2303OpenDevByUARTSetting(int index, BaudRate R, DataBits D, StopBits S, Parity P, FlowControl F) {
        UsbDeviceInfo usbDeviceInfo = null;
        if (this.ad == 0 || index < 0 || this.ad <= index) {
            return false;
        }
        if (index >= 0) {
            usbDeviceInfo = this.ac[index];
        }
        if (usbDeviceInfo == null || usbDeviceInfo.b() == null) {
            return false;
        }
        if (this.ab[index]) {
            return false;
        }
        this.ab[index] = true;
        if (!this.b(index)) {
            return false;
        }
        int n = 0;
        try {
            n = this.a(usbDeviceInfo.g(), index, usbDeviceInfo.h(), R, D, S, P, F);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (n < 0) {
            return false;
        }
        if (FlowControl.XONXOFF == F) {
            usbDeviceInfo.f(true);
        } else {
            usbDeviceInfo.f(false);
        }
        if (this.ag[index]) {
            this.a(this.af[index]);
        }
        String string = usbDeviceInfo.b().getDeviceName();
        return true;
    }

    public boolean OpenDevByUARTSetting(int index, BaudRate R, DataBits D, StopBits S, Parity P, FlowControl F) {
        return this.PL2303OpenDevByUARTSetting(index, R, D, S, P, F);
    }

    public void PL2303CloseDeviceByIndex(int index) {
        UsbDeviceInfo usbDeviceInfo = null;
        if (this.ad == 0 || index < 0 || this.ad <= index) {
            return;
        }
        if (index >= 0) {
            usbDeviceInfo = this.ac[index];
        }
        if (usbDeviceInfo == null || usbDeviceInfo.b() == null) {
            return;
        }
        this.ab[index] = false;
        if (this.ag[index]) {
            this.b(this.af[index]);
        }
    }

    private int a(int n, UsbDeviceInfo usbDeviceInfo) {
        int n2 = 0;
        int[] nArray = new int[2];
        UsbDeviceConnection usbDeviceConnection = usbDeviceInfo.g();
        if (usbDeviceInfo.i()) {
            usbDeviceInfo.a(4);
            n2 = this.a(usbDeviceConnection);
            if (n2 < 0) {
                return n2;
            }
        } else {
            if (!this.a(usbDeviceConnection, usbDeviceInfo) && (n2 = this.a(usbDeviceConnection)) < 0) {
                return n2;
            }
            if (4 == usbDeviceConnection.getRawDescriptors()[13]) {
                usbDeviceInfo.a(4);
            }
            if ((n2 = this.b(usbDeviceInfo)) < 0) {
                return n2;
            }
            if (usbDeviceInfo.l() && (n2 = this.c(usbDeviceInfo)) < 0) {
                return n2;
            }
            if (5 == usbDeviceConnection.getRawDescriptors()[13] && (n2 = this.a(usbDeviceInfo)) < 0) {
                return n2;
            }
        }
        if (4 != usbDeviceInfo.h() && 6 != usbDeviceInfo.h()) {
            return -1;
        }
        int n3 = 128;
        while (n3 <= 130) {
            nArray = this.a(usbDeviceConnection, n3);
            if (nArray[0] < 0) {
                return nArray[0];
            }
            ++n3;
        }
        try {
            n2 = this.a(usbDeviceConnection, n, usbDeviceInfo.h(), BaudRate.B9600, DataBits.D8, StopBits.S1, Parity.NONE, FlowControl.OFF);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (n2 < 0) {
            return n2;
        }
        usbDeviceInfo.f(false);
        return 0;
    }

    private int a(UsbDeviceInfo usbDeviceInfo) {
        int[] nArray = new int[2];
        int n = 148;
        UsbDeviceConnection usbDeviceConnection = usbDeviceInfo.g();
        nArray = this.a(usbDeviceConnection, 148);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        if ((nArray[1] & n) == n) {
            usbDeviceInfo.a(6);
        } else {
            usbDeviceInfo.a(2);
        }
        return 0;
    }

    private int b(UsbDeviceInfo usbDeviceInfo) {
        int[] nArray = new int[2];
        int n = 255;
        int[] nArray2 = new int[2];
        UsbDeviceConnection usbDeviceConnection = usbDeviceInfo.g();
        nArray = this.a(usbDeviceConnection, 129);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        int n2 = nArray[1];
        nArray[0] = this.a(usbDeviceConnection, 1, n);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        nArray = this.a(usbDeviceConnection, 129);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        if ((nArray[1] & 0xF) == 15) {
            usbDeviceInfo.a(4);
            nArray = this.b(usbDeviceConnection, 250);
            if (nArray[0] < 0) {
                return nArray[0];
            }
            nArray2[0] = nArray[1];
            nArray = this.b(usbDeviceConnection, 251);
            if (nArray[0] < 0) {
                return nArray[0];
            }
            nArray2[1] = nArray[1];
            if (nArray2[0] == 1 && nArray2[1] == 4) {
                usbDeviceInfo.a(2);
            } else if (!(nArray2[0] == 2 && nArray2[1] == 4 || nArray2[0] == 3 && nArray2[1] == 4 || nArray2[0] != 1 || nArray2[1] != 3)) {
                usbDeviceInfo.a(2);
            }
        } else {
            usbDeviceInfo.a(2);
        }
        nArray[0] = this.a(usbDeviceConnection, 1, n2);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        return 0;
    }

    private int c(UsbDeviceInfo usbDeviceInfo) {
        int[] nArray = new int[2];
        UsbDeviceConnection usbDeviceConnection = usbDeviceInfo.g();
        nArray = this.a(usbDeviceConnection, 129);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        if ((nArray[1] & 8) == 8) {
            nArray[0] = this.a(usbDeviceConnection, 0, 49);
            if (nArray[0] < 0) {
                return nArray[0];
            }
            nArray[0] = this.a(usbDeviceConnection, 1, 8);
            if (nArray[0] < 0) {
                return nArray[0];
            }
            usbDeviceInfo.c(true);
        }
        return nArray[0];
    }

    public int PL2303SetupCOMPort(int index, BaudRate R, DataBits D, StopBits S, Parity P, FlowControl F) throws IOException {
        UsbDeviceInfo usbDeviceInfo = null;
        int[] nArray = new int[2];
        if (this.ad == 0 || index < 0) {
            return -1;
        }
        if (index >= 0) {
            usbDeviceInfo = this.ac[index];
        }
        if (usbDeviceInfo == null || usbDeviceInfo.b() == null) {
            return -2;
        }
        if (usbDeviceInfo.n() && !usbDeviceInfo.m()) {
            return 0;
        }
        int n = 0;
        try {
            n = this.a(usbDeviceInfo.g(), index, usbDeviceInfo.h(), R, D, S, P, F);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (n < 0) {
            return -3;
        }
        if (FlowControl.XONXOFF == F) {
            usbDeviceInfo.f(true);
        } else {
            usbDeviceInfo.f(false);
        }
        if (usbDeviceInfo.k()) {
            nArray[0] = this.a(usbDeviceInfo.g(), 0, 49);
            if (nArray[0] < 0) {
                return nArray[0];
            }
            nArray[0] = this.a(usbDeviceInfo.g(), 1, 8);
            if (nArray[0] < 0) {
                return nArray[0];
            }
        }
        return n;
    }

    public int setup(int index, BaudRate R, DataBits D, StopBits S, Parity P, FlowControl F) throws IOException {
        return this.PL2303SetupCOMPort(index, R, D, S, P, F);
    }

    private int a(UsbDeviceConnection usbDeviceConnection, int n, int n2, BaudRate baudRate, DataBits dataBits, StopBits stopBits, Parity parity, FlowControl flowControl) throws IOException {
        int n3 = 0;
        if (usbDeviceConnection == null) {
            return -1;
        }
        n3 = usbDeviceConnection.controlTransfer(161, 33, 0, 0, this.N, 7, this.Q);
        if (n3 < 0) {
            return n3;
        }
        int n4 = 0;
        switch (PL2303MultiLib.b()[baudRate.ordinal()]) {
            case 1: {
                n4 = 0;
                break;
            }
            case 2: {
                n4 = 75;
                break;
            }
            case 3: {
                n4 = 150;
                break;
            }
            case 4: {
                n4 = 300;
                break;
            }
            case 5: {
                n4 = 600;
                break;
            }
            case 6: {
                n4 = 1200;
                break;
            }
            case 7: {
                n4 = 1800;
                break;
            }
            case 8: {
                n4 = 2400;
                break;
            }
            case 9: {
                n4 = 4800;
                break;
            }
            case 10: {
                n4 = 9600;
                break;
            }
            case 11: {
                n4 = 14400;
                break;
            }
            case 12: {
                n4 = 19200;
                break;
            }
            case 13: {
                n4 = 38400;
                break;
            }
            case 14: {
                n4 = 57600;
                break;
            }
            case 15: {
                n4 = 115200;
                break;
            }
            case 16: {
                n4 = 230400;
                break;
            }
            case 17: {
                n4 = 460800;
                break;
            }
            case 18: {
                n4 = 614400;
                break;
            }
            case 19: {
                n4 = 921600;
                break;
            }
            case 20: {
                n4 = 1228800;
                break;
            }
            case 21: {
                n4 = 2457600;
                break;
            }
            case 22: {
                n4 = 3000000;
                break;
            }
            case 23: {
                n4 = 6000000;
                break;
            }
            default: {
                return -2;
            }
        }
        if (n4 > 1228800 && n2 == 0) {
            return -2;
        }
        if (this.af[n].c != null) {
            this.a(this.af[n], baudRate);
        }
        this.N[0] = (byte)(n4 & 0xFF);
        this.N[1] = (byte)(n4 >> 8 & 0xFF);
        this.N[2] = (byte)(n4 >> 16 & 0xFF);
        this.N[3] = (byte)(n4 >> 24 & 0xFF);
        switch (PL2303MultiLib.c()[stopBits.ordinal()]) {
            case 1: {
                this.N[4] = 0;
                break;
            }
            case 2: {
                this.N[4] = 2;
                break;
            }
            default: {
                return -3;
            }
        }
        switch (PL2303MultiLib.d()[parity.ordinal()]) {
            case 1: {
                this.N[5] = 0;
                break;
            }
            case 2: {
                this.N[5] = 1;
                break;
            }
            case 3: {
                this.N[5] = 2;
                break;
            }
            default: {
                return -4;
            }
        }
        switch (PL2303MultiLib.e()[dataBits.ordinal()]) {
            case 1: {
                this.N[6] = 5;
                break;
            }
            case 2: {
                this.N[6] = 6;
                break;
            }
            case 3: {
                this.N[6] = 7;
                break;
            }
            case 4: {
                this.N[6] = 8;
                break;
            }
            default: {
                return -5;
            }
        }
        n3 = usbDeviceConnection.controlTransfer(33, 32, 0, 0, this.N, 7, this.Q);
        if (n3 < 0) {
            return n3;
        }
        n3 = usbDeviceConnection.controlTransfer(33, 35, 0, 0, null, 0, this.Q);
        if (n3 < 0) {
            return n3;
        }
        switch (PL2303MultiLib.f()[flowControl.ordinal()]) {
            case 1: {
                n3 = usbDeviceConnection.controlTransfer(64, 1, 0, 0, null, 0, this.Q);
                if (n3 < 0) {
                    return n3;
                }
                n3 = usbDeviceConnection.controlTransfer(64, 1, 1, 0, null, 0, this.Q);
                if (n3 < 0) {
                    return n3;
                }
                n3 = usbDeviceConnection.controlTransfer(64, 1, 2, 68, null, 0, this.Q);
                if (n3 >= 0) break;
                return n3;
            }
            case 2: {
                n3 = usbDeviceConnection.controlTransfer(64, 1, 0, 97, null, 0, this.Q);
                if (n3 < 0) {
                    return n3;
                }
                n3 = usbDeviceConnection.controlTransfer(64, 1, 1, 0, null, 0, this.Q);
                if (n3 < 0) {
                    return n3;
                }
                n3 = usbDeviceConnection.controlTransfer(64, 1, 2, 68, null, 0, this.Q);
                if (n3 >= 0) break;
                return n3;
            }
            case 3: {
                break;
            }
            case 4: {
                if (4 != n2) break;
                n3 = usbDeviceConnection.controlTransfer(64, 1, 0, 73, null, 0, this.Q);
                if (n3 < 0) {
                    Log.d((String)T, (String)"fail to setup");
                    return n3;
                }
                n3 = usbDeviceConnection.controlTransfer(64, 1, 1, 5, null, 0, this.Q);
                if (n3 < 0) {
                    Log.d((String)T, (String)"fail to setup");
                    return n3;
                }
                n3 = usbDeviceConnection.controlTransfer(64, 1, 2, 68, null, 0, this.Q);
                if (n3 >= 0) break;
                Log.d((String)T, (String)"fail to setup");
                return n3;
            }
            case 5: {
                if (4 != n2) break;
                n3 = usbDeviceConnection.controlTransfer(64, 1, 0, 105, null, 0, this.Q);
                if (n3 < 0) {
                    Log.d((String)T, (String)"fail to setup");
                    return n3;
                }
                n3 = usbDeviceConnection.controlTransfer(64, 1, 1, 7, null, 0, this.Q);
                if (n3 < 0) {
                    Log.d((String)T, (String)"fail to setup");
                    return n3;
                }
                n3 = usbDeviceConnection.controlTransfer(64, 1, 2, 68, null, 0, this.Q);
                if (n3 >= 0) break;
                Log.d((String)T, (String)"fail to setup");
                return n3;
            }
            case 6: {
                n3 = usbDeviceConnection.controlTransfer(64, 1, 0, 193, null, 0, this.Q);
                if (n3 < 0) {
                    Log.d((String)T, (String)"fail to setup");
                    return n3;
                }
                n3 = usbDeviceConnection.controlTransfer(64, 1, 1, 0, null, 0, this.Q);
                if (n3 < 0) {
                    Log.d((String)T, (String)"fail to setup");
                    return n3;
                }
                n3 = usbDeviceConnection.controlTransfer(64, 1, 2, 68, null, 0, this.Q);
                if (n3 >= 0) break;
                Log.d((String)T, (String)"fail to setup");
                return n3;
            }
            default: {
                return -6;
            }
        }
        return 0;
    }

    private static void a(Object object) {
        Log.d((String)"PL2303Multi_USB", (String)("L: " + object.toString()));
    }

    public boolean PL2303Device_IsSupportChip(int index) {
        boolean bl = false;
        UsbDeviceInfo usbDeviceInfo = null;
        usbDeviceInfo = this.ac[index];
        if (4 == usbDeviceInfo.h()) {
            bl = true;
        } else if (6 == usbDeviceInfo.h()) {
            bl = true;
        }
        return bl;
    }

    private String c(int n) {
        char[] cArray = new char[]{Character.forDigit(n >> 4 & 0xF, 16), Character.forDigit(n & 0xF, 16)};
        String string = new String(cArray);
        return string;
    }

    private static String a(byte[] byArray, int n) {
        StringBuffer stringBuffer = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
            messageDigest.reset();
            byte[] byArray2 = messageDigest.digest(byArray);
            stringBuffer = new StringBuffer();
            byte[] byArray3 = byArray2;
            int n2 = byArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                byte by = byArray3[n3];
                stringBuffer.append(String.format("%02X", by));
                ++n3;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    private int a(UsbDeviceConnection usbDeviceConnection, int n, int n2) {
        int n3 = 0;
        if (usbDeviceConnection == null) {
            return -1;
        }
        n3 = usbDeviceConnection.controlTransfer(64, 1, n, n2, null, 0, this.Q);
        if (n3 < 0) {
            return n3;
        }
        return n3;
    }

    private int[] a(UsbDeviceConnection usbDeviceConnection, int n) {
        int[] nArray = new int[2];
        byte[] byArray = new byte[1];
        nArray[0] = 0;
        if (usbDeviceConnection == null) {
            nArray[0] = -1;
            return nArray;
        }
        nArray[0] = usbDeviceConnection.controlTransfer(192, 1, n, 0, byArray, 1, this.Q);
        if (nArray[0] < 0) {
            return nArray;
        }
        nArray[1] = byArray[0];
        return nArray;
    }

    private int[] b(UsbDeviceConnection usbDeviceConnection, int n) {
        int[] nArray = new int[2];
        nArray[0] = 0;
        nArray = this.a(usbDeviceConnection, 132);
        if (nArray[0] < 0) {
            return nArray;
        }
        nArray[0] = this.a(usbDeviceConnection, 4, n);
        if (nArray[0] < 0) {
            return nArray;
        }
        nArray = this.a(usbDeviceConnection, 132);
        if (nArray[0] < 0) {
            return nArray;
        }
        nArray = this.a(usbDeviceConnection, 131);
        if (nArray[0] < 0) {
            return nArray;
        }
        return nArray;
    }

    private boolean a(UsbDeviceConnection usbDeviceConnection, UsbDeviceInfo usbDeviceInfo) {
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int n = 0;
        while (n < 2) {
            nArray = this.a(usbDeviceConnection, 132);
            if (nArray[0] < 0) {
                usbDeviceInfo.d(false);
                return false;
            }
            nArray[0] = this.a(usbDeviceConnection, 4, n);
            if (nArray[0] < 0) {
                usbDeviceInfo.d(false);
                return false;
            }
            nArray = this.a(usbDeviceConnection, 132);
            if (nArray[0] < 0) {
                usbDeviceInfo.d(false);
                return false;
            }
            nArray = this.a(usbDeviceConnection, 131);
            if (nArray[0] < 0) {
                usbDeviceInfo.d(false);
                return false;
            }
            nArray2[n] = nArray[1];
            ++n;
        }
        if (nArray2[0] == 123 && nArray2[1] == 6) {
            usbDeviceInfo.d(true);
        } else {
            usbDeviceInfo.d(false);
        }
        return usbDeviceInfo.l();
    }

    private int a(UsbDeviceConnection usbDeviceConnection) {
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 68;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[2];
        nArray3[0] = this.a(usbDeviceConnection, 2056, 0);
        if (nArray3[0] < 0) {
            return nArray3[0];
        }
        nArray3[0] = this.a(usbDeviceConnection, 2313, 0);
        if (nArray3[0] < 0) {
            return nArray3[0];
        }
        int n = 0;
        while (n <= 2) {
            nArray3[0] = this.a(usbDeviceConnection, n, nArray2[n]);
            if (nArray3[0] < 0) {
                return nArray3[0];
            }
            ++n;
        }
        int n2 = 128;
        while (n2 <= 130) {
            nArray3 = this.a(usbDeviceConnection, n2);
            if (nArray3[0] < 0) {
                return nArray3[0];
            }
            ++n2;
        }
        return nArray3[0];
    }

    public boolean PL2303Device_SetCommTimeouts(int TimeoutConstant) {
        if (TimeoutConstant < 0) {
            return false;
        }
        this.O = TimeoutConstant;
        this.P = TimeoutConstant;
        return true;
    }

    public boolean PL2303Device_GetCommTimeouts(int TimeoutConstant) {
        TimeoutConstant = this.P;
        return true;
    }

    public String PL2303Device_GetSerialNumber(int index) {
        UsbDeviceInfo usbDeviceInfo = null;
        UsbDeviceConnection usbDeviceConnection = null;
        if (this.ad == 0 || index < 0) {
            return null;
        }
        if (index >= 0) {
            usbDeviceInfo = this.ac[index];
        }
        if (usbDeviceInfo == null || usbDeviceInfo.b() == null) {
            return null;
        }
        usbDeviceConnection = usbDeviceInfo.g();
        if (usbDeviceConnection == null) {
            return null;
        }
        return usbDeviceConnection.getSerial();
    }

    public int PL2303TB_Set_PWM(int index, int PWM_IO_Num, byte Frequency_value, byte Duty_value) {
        int n;
        int[] nArray = new int[2];
        int n2 = 0;
        UsbDeviceInfo usbDeviceInfo = null;
        UsbDeviceConnection usbDeviceConnection = null;
        if (this.ad == 0 || index < 0) {
            return -1;
        }
        if (index >= 0) {
            usbDeviceInfo = this.ac[index];
        }
        if (usbDeviceInfo == null || usbDeviceInfo.b() == null) {
            return -2;
        }
        usbDeviceConnection = usbDeviceInfo.g();
        if (usbDeviceConnection == null) {
            return -1;
        }
        n2 = Duty_value & 0xFF;
        n2 <<= 8;
        n2 += Frequency_value;
        switch (PWM_IO_Num) {
            case 0: {
                nArray[0] = this.a(usbDeviceConnection, 2, 0);
                if (nArray[0] < 0) {
                    return nArray[0];
                }
                n = 16;
                break;
            }
            case 1: {
                n = 17;
                break;
            }
            case 2: {
                n = 18;
                break;
            }
            case 3: {
                n = 19;
                break;
            }
            default: {
                return -1;
            }
        }
        nArray[0] = this.a(usbDeviceConnection, n, n2);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        return 0;
    }

    public int PL2303TB_Enable_GPIO(int index, int GPIO_Num, boolean Enable) {
        int[] nArray = new int[2];
        int n = 0;
        UsbDeviceInfo usbDeviceInfo = null;
        UsbDeviceConnection usbDeviceConnection = null;
        if (this.ad == 0 || index < 0) {
            return -1;
        }
        if (index >= 0) {
            usbDeviceInfo = this.ac[index];
        }
        if (usbDeviceInfo == null || usbDeviceInfo.b() == null) {
            return -2;
        }
        usbDeviceConnection = usbDeviceInfo.g();
        if (usbDeviceConnection == null) {
            return -1;
        }
        if (GPIO_Num == 6 || GPIO_Num == 7 || GPIO_Num == 9) {
            nArray[0] = this.a(usbDeviceConnection, 2, 0);
            if (nArray[0] < 0) {
                return nArray[0];
            }
        }
        n = usbDeviceInfo.a(UsbDeviceInfo.GPIOPin.GPIO_TB_12);
        switch (GPIO_Num) {
            case 0: {
                if (Enable) {
                    n |= 1;
                    break;
                }
                n &= 0xFFFFFFFE;
                break;
            }
            case 1: {
                if (Enable) {
                    n |= 2;
                    break;
                }
                n &= 0xFFFFFFFD;
                break;
            }
            case 2: {
                if (Enable) {
                    n |= 4;
                    break;
                }
                n &= 0xFFFFFFFB;
                break;
            }
            case 3: {
                if (Enable) {
                    n |= 8;
                    break;
                }
                n &= 0xFFFFFFF7;
                break;
            }
            case 4: {
                if (Enable) {
                    n |= 0x10;
                    break;
                }
                n &= 0xFFFFFFEF;
                break;
            }
            case 5: {
                if (Enable) {
                    n |= 0x20;
                    break;
                }
                n &= 0xFFFFFFDF;
                break;
            }
            case 6: {
                if (Enable) {
                    n |= 0x40;
                    break;
                }
                n &= 0xFFFFFFBF;
                break;
            }
            case 7: {
                if (Enable) {
                    n |= 0x80;
                    break;
                }
                n &= 0xFFFFFF7F;
                break;
            }
            case 8: {
                if (Enable) {
                    n |= 0x100;
                    break;
                }
                n &= 0xFFFFFEFF;
                break;
            }
            case 9: {
                if (Enable) {
                    n |= 0x200;
                    break;
                }
                n &= 0xFFFFFDFF;
                break;
            }
            case 10: {
                if (Enable) {
                    n |= 0x400;
                    break;
                }
                n &= 0xFFFFFBFF;
                break;
            }
            case 11: {
                if (Enable) {
                    n |= 0x800;
                    break;
                }
                n &= 0xFFFFF7FF;
                break;
            }
            default: {
                return -1;
            }
        }
        nArray[0] = this.a(usbDeviceConnection, 14, n);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        return 0;
    }

    private String a(String string, int n) {
        boolean bl = false;
        int[] nArray = new int[3];
        String string2 = Z;
        if (n > 8) {
            string2 = "";
            return "";
        }
        bl = this.d(n);
        if (!bl) {
            return string2;
        }
        bl = this.a(n, nArray);
        if (!bl) {
            return string2;
        }
        string2 = this.a(nArray);
        return string2;
    }

    private String a(int[] nArray) {
        String string = "";
        if (nArray[2] == 0 && nArray[1] == 0 && nArray[0] == 1) {
            string = "COM1";
        }
        if (nArray[2] == 0 && nArray[1] == 1 && nArray[0] == 0) {
            string = "COM2";
        }
        if (nArray[2] == 0 && nArray[1] == 1 && nArray[0] == 1) {
            string = "COM3";
        }
        if (nArray[2] == 1 && nArray[1] == 0 && nArray[0] == 0) {
            string = "COM4";
        }
        if (nArray[2] == 1 && nArray[1] == 0 && nArray[0] == 1) {
            string = "COM5";
        }
        if (nArray[2] == 1 && nArray[1] == 1 && nArray[0] == 0) {
            string = "COM6";
        }
        if (nArray[2] == 1 && nArray[1] == 1 && nArray[0] == 1) {
            string = "COM7";
        }
        if (nArray[2] == 0 && nArray[1] == 0 && nArray[0] == 0) {
            string = "COM8";
        }
        return string;
    }

    private boolean d(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 3) {
            n2 = this.PL2303HXD_Enable_GPIO(n, n3, false);
            if (n2 < 0) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private boolean a(int n, int[] nArray) {
        int[] nArray2 = new int[2];
        nArray2 = this.PL2303HXD_Get_GPIO_Value(n, 2);
        if (nArray2[0] < 0) {
            // empty if block
        }
        nArray[2] = nArray2[1];
        nArray2 = this.PL2303HXD_Get_GPIO_Value(n, 1);
        if (nArray2[0] < 0) {
            // empty if block
        }
        nArray[1] = nArray2[1];
        nArray2 = this.PL2303HXD_Get_GPIO_Value(n, 0);
        if (nArray2[0] < 0) {
            // empty if block
        }
        nArray[0] = nArray2[1];
        return true;
    }

    private String b(String string, int n) {
        boolean bl = false;
        int[] nArray = new int[2];
        String string2 = Z;
        bl = this.e(n);
        if (!bl) {
            return string2;
        }
        bl = this.b(n, nArray);
        if (!bl) {
            return string2;
        }
        string2 = this.b(nArray);
        return string2;
    }

    private boolean e(int n) {
        int n2 = 0;
        int n3 = 2;
        while (n3 < 4) {
            n2 = this.PL2303HXD_Enable_GPIO(n, n3, false);
            if (n2 < 0) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private boolean b(int n, int[] nArray) {
        int[] nArray2 = new int[2];
        nArray2 = this.PL2303HXD_Get_GPIO_Value(n, 2);
        if (nArray2[0] < 0) {
            // empty if block
        }
        nArray[1] = nArray2[1];
        nArray2 = this.PL2303HXD_Get_GPIO_Value(n, 3);
        if (nArray2[0] < 0) {
            // empty if block
        }
        nArray[0] = nArray2[1];
        return true;
    }

    private String b(int[] nArray) {
        String string = "";
        if (nArray[1] == 0 && nArray[0] == 0) {
            string = "COM1";
        }
        if (nArray[1] == 1 && nArray[0] == 0) {
            string = "COM2";
        }
        if (nArray[1] == 0 && nArray[0] == 1) {
            string = "COM3";
        }
        if (nArray[1] == 1 && nArray[0] == 1) {
            string = "COM4";
        }
        return string;
    }

    public int PL2303HXD_Enable_GPIO(int index, int GPIO_Num, boolean Enable) {
        int[] nArray = new int[2];
        int n = 0;
        UsbDeviceInfo usbDeviceInfo = null;
        UsbDeviceConnection usbDeviceConnection = null;
        if (this.ad == 0 || index < 0) {
            return -1;
        }
        if (index >= 0) {
            usbDeviceInfo = this.ac[index];
        }
        if (usbDeviceInfo == null || usbDeviceInfo.b() == null) {
            return -2;
        }
        usbDeviceConnection = usbDeviceInfo.g();
        switch (GPIO_Num) {
            case 0: {
                nArray = this.a(usbDeviceConnection, 129);
                if (nArray[0] < 0) {
                    return nArray[0];
                }
                n = Enable ? (nArray[1] = nArray[1] | 0x10) : (nArray[1] = nArray[1] & 0xFFFFFFEF);
                nArray[0] = this.a(usbDeviceConnection, 1, n);
                if (nArray[0] >= 0) break;
                return nArray[0];
            }
            case 1: {
                nArray = this.a(usbDeviceConnection, 129);
                if (nArray[0] < 0) {
                    return nArray[0];
                }
                n = Enable ? (nArray[1] = nArray[1] | 0x20) : (nArray[1] = nArray[1] & 0xFFFFFFDF);
                nArray[0] = this.a(usbDeviceConnection, 1, n);
                if (nArray[0] >= 0) break;
                return nArray[0];
            }
            case 2: {
                n = usbDeviceInfo.a(UsbDeviceInfo.GPIOPin.GPIO_23);
                n = Enable ? (n |= 3) : (n &= 0xFFFFFFFC);
                usbDeviceInfo.a(UsbDeviceInfo.GPIOPin.GPIO_23, n);
                nArray[0] = this.a(usbDeviceConnection, 12, n);
                if (nArray[0] >= 0) break;
                return nArray[0];
            }
            case 3: {
                n = usbDeviceInfo.a(UsbDeviceInfo.GPIOPin.GPIO_23);
                n = Enable ? (n |= 0xC) : (n &= 0xFFFFFFF3);
                usbDeviceInfo.b(UsbDeviceInfo.GPIOPin.GPIO_23, n);
                nArray[0] = this.a(usbDeviceConnection, 12, n);
                if (nArray[0] >= 0) break;
                return nArray[0];
            }
            case 4: {
                n = usbDeviceInfo.a(UsbDeviceInfo.GPIOPin.GPIO_4567);
                n = Enable ? (n |= 3) : (n &= 0xFFFFFFFC);
                usbDeviceInfo.a(UsbDeviceInfo.GPIOPin.GPIO_4567, n);
                nArray[0] = this.a(usbDeviceConnection, 6, n);
                break;
            }
            case 5: {
                n = usbDeviceInfo.a(UsbDeviceInfo.GPIOPin.GPIO_4567);
                n = Enable ? (n |= 0xC) : (n &= 0xFFFFFFF3);
                usbDeviceInfo.a(UsbDeviceInfo.GPIOPin.GPIO_4567, n);
                nArray[0] = this.a(usbDeviceConnection, 6, n);
                break;
            }
            case 6: {
                n = usbDeviceInfo.a(UsbDeviceInfo.GPIOPin.GPIO_4567);
                n = Enable ? (n |= 0x30) : (n &= 0xFFFFFFCF);
                usbDeviceInfo.a(UsbDeviceInfo.GPIOPin.GPIO_4567, n);
                nArray[0] = this.a(usbDeviceConnection, 6, n);
                break;
            }
            case 7: {
                n = usbDeviceInfo.a(UsbDeviceInfo.GPIOPin.GPIO_4567);
                n = Enable ? (n |= 0xC0) : (n &= 0xFFFFFF3F);
                usbDeviceInfo.a(UsbDeviceInfo.GPIOPin.GPIO_4567, n);
                nArray[0] = this.a(usbDeviceConnection, 6, n);
                break;
            }
            default: {
                return -1;
            }
        }
        return 0;
    }

    public int PL2303TB_Set_GPIO_Value(int index, int GPIO_Num, int val) {
        int[] nArray = new int[2];
        int n = 0;
        UsbDeviceInfo usbDeviceInfo = null;
        UsbDeviceConnection usbDeviceConnection = null;
        if (this.ad == 0 || index < 0) {
            return -1;
        }
        if (index >= 0) {
            usbDeviceInfo = this.ac[index];
        }
        if (usbDeviceInfo == null || usbDeviceInfo.b() == null) {
            return -2;
        }
        usbDeviceConnection = usbDeviceInfo.g();
        if (usbDeviceConnection == null) {
            return -1;
        }
        nArray = this.a(usbDeviceConnection, 143);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        switch (GPIO_Num) {
            case 0: {
                if (val == 1) {
                    n |= 1;
                    break;
                }
                n &= 0xFFFFFFFE;
                break;
            }
            case 1: {
                if (val == 1) {
                    n |= 2;
                    break;
                }
                n &= 0xFFFFFFFD;
                break;
            }
            case 2: {
                if (val == 1) {
                    n |= 4;
                    break;
                }
                n &= 0xFFFFFFFB;
                break;
            }
            case 3: {
                if (val == 1) {
                    n |= 4;
                    break;
                }
                n &= 0xFFFFFFFB;
                break;
            }
            case 4: {
                if (val == 1) {
                    n |= 0x10;
                    break;
                }
                n &= 0xFFFFFFEF;
                break;
            }
            case 5: {
                if (val == 1) {
                    n |= 0x20;
                    break;
                }
                n &= 0xFFFFFFDF;
                break;
            }
            case 6: {
                if (val == 1) {
                    n |= 0x40;
                    break;
                }
                n &= 0xFFFFFFBF;
                break;
            }
            case 7: {
                if (val == 1) {
                    n |= 0x80;
                    break;
                }
                n &= 0xFFFFFF7F;
                break;
            }
            case 8: {
                if (val == 1) {
                    n |= 0x100;
                    break;
                }
                n &= 0xFFFFFEFF;
                break;
            }
            case 9: {
                if (val == 1) {
                    n |= 0x200;
                    break;
                }
                n &= 0xFFFFFDFF;
                break;
            }
            case 10: {
                if (val == 1) {
                    n |= 0x400;
                    break;
                }
                n &= 0xFFFFFBFF;
                break;
            }
            case 11: {
                if (val == 1) {
                    n |= 0x800;
                    break;
                }
                n &= 0xFFFFF7FF;
                break;
            }
            default: {
                return -1;
            }
        }
        nArray[0] = this.a(usbDeviceConnection, 15, n);
        if (nArray[0] < 0) {
            return nArray[0];
        }
        return 0;
    }

    public int PL2303HXD_Set_GPIO_Value(int index, int GPIO_Num, int val) {
        int[] nArray = new int[2];
        int n = 0;
        int n2 = 0;
        UsbDeviceInfo usbDeviceInfo = null;
        UsbDeviceConnection usbDeviceConnection = null;
        if (this.ad == 0 || index < 0) {
            return -1;
        }
        if (index >= 0) {
            usbDeviceInfo = this.ac[index];
        }
        if (usbDeviceInfo == null || usbDeviceInfo.b() == null) {
            return -2;
        }
        usbDeviceConnection = usbDeviceInfo.g();
        switch (GPIO_Num) {
            case 0: {
                nArray = this.a(usbDeviceConnection, 129);
                if (nArray[0] < 0) {
                    return nArray[0];
                }
                n = val == 1 ? (nArray[1] = nArray[1] | 0x40) : (nArray[1] = nArray[1] & 0xFFFFFFBF);
                nArray[0] = this.a(usbDeviceConnection, 1, n);
                if (nArray[0] >= 0) break;
                return nArray[0];
            }
            case 1: {
                nArray = this.a(usbDeviceConnection, 129);
                if (nArray[0] < 0) {
                    return nArray[0];
                }
                n = val == 1 ? (nArray[1] = nArray[1] | 0x80) : (nArray[1] = nArray[1] & 0xFFFFFF7F);
                nArray[0] = this.a(usbDeviceConnection, 1, n);
                if (nArray[0] >= 0) break;
                return nArray[0];
            }
            case 2: {
                nArray = this.a(usbDeviceConnection, 141);
                if (nArray[0] < 0) {
                    return nArray[0];
                }
                n = val == 1 ? (nArray[1] = nArray[1] | 1) : (nArray[1] = nArray[1] & 0xFFFFFFFE);
                nArray[0] = this.a(usbDeviceConnection, 13, n);
                if (nArray[0] >= 0) break;
                return nArray[0];
            }
            case 3: {
                nArray = this.a(usbDeviceConnection, 141);
                if (nArray[0] < 0) {
                    return nArray[0];
                }
                n = val == 1 ? (nArray[1] = nArray[1] | 2) : (nArray[1] = nArray[1] & 0xFFFFFFFD);
                nArray[0] = this.a(usbDeviceConnection, 13, n);
                if (nArray[0] >= 0) break;
                return nArray[0];
            }
            case 4: {
                n2 = usbDeviceInfo.c(UsbDeviceInfo.GPIOPin.GPIO_4567);
                n = n2 == 0 ? 0 : n2;
                n = val == 1 ? (n |= 1) : (n &= 0xFFFFFFFE);
                n2 = n;
                usbDeviceInfo.c(UsbDeviceInfo.GPIOPin.GPIO_4567, n2);
                nArray[0] = this.a(usbDeviceConnection, 7, n);
                if (nArray[0] >= 0) break;
                return nArray[0];
            }
            case 5: {
                n2 = usbDeviceInfo.c(UsbDeviceInfo.GPIOPin.GPIO_4567);
                n = n2 == 0 ? 0 : n2;
                n = val == 1 ? (n |= 2) : (n &= 0xFFFFFFFD);
                n2 = n;
                usbDeviceInfo.c(UsbDeviceInfo.GPIOPin.GPIO_4567, n2);
                nArray[0] = this.a(usbDeviceConnection, 7, n);
                if (nArray[0] >= 0) break;
                return nArray[0];
            }
            case 6: {
                n2 = usbDeviceInfo.c(UsbDeviceInfo.GPIOPin.GPIO_4567);
                n = n2 == 0 ? 0 : n2;
                n = val == 1 ? (n |= 4) : (n &= 0xFFFFFFFB);
                n2 = n;
                usbDeviceInfo.c(UsbDeviceInfo.GPIOPin.GPIO_4567, n2);
                nArray[0] = this.a(usbDeviceConnection, 7, n);
                if (nArray[0] >= 0) break;
                return nArray[0];
            }
            case 7: {
                n2 = usbDeviceInfo.c(UsbDeviceInfo.GPIOPin.GPIO_4567);
                n = n2 == 0 ? 0 : n2;
                n = val == 1 ? (n |= 8) : (n &= 0xFFFFFFF7);
                n2 = n;
                usbDeviceInfo.c(UsbDeviceInfo.GPIOPin.GPIO_4567, n2);
                nArray[0] = this.a(usbDeviceConnection, 7, n);
                if (nArray[0] >= 0) break;
                return nArray[0];
            }
            default: {
                return -1;
            }
        }
        return 0;
    }

    public int[] PL2303HXD_Get_GPIO_Value(int index, int GPIO_Num) {
        int[] nArray = new int[2];
        UsbDeviceInfo usbDeviceInfo = null;
        UsbDeviceConnection usbDeviceConnection = null;
        if (this.ad == 0 || index < 0) {
            nArray[0] = -1;
            return nArray;
        }
        if (index >= 0) {
            usbDeviceInfo = this.ac[index];
        }
        if (usbDeviceInfo == null || usbDeviceInfo.b() == null) {
            nArray[0] = -2;
            return nArray;
        }
        usbDeviceConnection = usbDeviceInfo.g();
        switch (GPIO_Num) {
            case 0: {
                nArray = this.a(usbDeviceConnection, 129);
                if (nArray[0] < 0) {
                    return nArray;
                }
                if ((nArray[1] & 0x40) == 64) {
                    nArray[1] = 1;
                    break;
                }
                nArray[1] = 0;
                break;
            }
            case 1: {
                nArray = this.a(usbDeviceConnection, 129);
                if (nArray[0] < 0) {
                    return nArray;
                }
                if ((nArray[1] & 0x80) == 128) {
                    nArray[1] = 1;
                    break;
                }
                nArray[1] = 0;
                break;
            }
            case 2: {
                nArray = this.a(usbDeviceConnection, 141);
                if (nArray[0] < 0) {
                    return nArray;
                }
                if ((nArray[1] & 1) == 1) {
                    nArray[1] = 1;
                    break;
                }
                nArray[1] = 0;
                break;
            }
            case 3: {
                nArray = this.a(usbDeviceConnection, 141);
                if (nArray[0] < 0) {
                    return nArray;
                }
                if ((nArray[1] & 2) == 2) {
                    nArray[1] = 1;
                    break;
                }
                nArray[1] = 0;
                break;
            }
            case 4: {
                nArray = this.a(usbDeviceConnection, 135);
                if (nArray[0] < 0) {
                    return nArray;
                }
                if ((nArray[1] & 1) == 1) {
                    nArray[1] = 1;
                    break;
                }
                nArray[1] = 0;
                break;
            }
            case 5: {
                nArray = this.a(usbDeviceConnection, 135);
                if (nArray[0] < 0) {
                    return nArray;
                }
                if ((nArray[1] & 2) == 2) {
                    nArray[1] = 1;
                    break;
                }
                nArray[1] = 0;
                break;
            }
            case 6: {
                nArray = this.a(usbDeviceConnection, 135);
                if (nArray[0] < 0) {
                    return nArray;
                }
                if ((nArray[1] & 4) == 4) {
                    nArray[1] = 1;
                    break;
                }
                nArray[1] = 0;
                break;
            }
            case 7: {
                nArray = this.a(usbDeviceConnection, 135);
                if (nArray[0] < 0) {
                    return nArray;
                }
                if ((nArray[1] & 8) == 8) {
                    nArray[1] = 1;
                    break;
                }
                nArray[1] = 0;
                break;
            }
            default: {
                nArray[0] = -1;
                return nArray;
            }
        }
        return nArray;
    }

    public int PL2303HXD_SetDTR(int index, boolean state) {
        int n;
        UsbDeviceInfo usbDeviceInfo = null;
        UsbDeviceConnection usbDeviceConnection = null;
        if (this.ad == 0 || index < 0 || this.ad <= index) {
            return -1;
        }
        if (index >= 0) {
            usbDeviceInfo = this.ac[index];
        }
        if (usbDeviceInfo == null || usbDeviceInfo.b() == null) {
            return -2;
        }
        usbDeviceConnection = usbDeviceInfo.g();
        int n2 = usbDeviceInfo.a(UsbDeviceInfo.MODEMCtrlPin.MODEM_DTRRTS);
        if (state && 1 != (n2 & 1)) {
            ++n2;
        }
        if (!state && 1 == (n2 & 1)) {
            --n2;
        }
        if ((n = usbDeviceConnection.controlTransfer(33, 34, n2, 0, null, 0, this.Q)) < 0) {
            return -3;
        }
        usbDeviceInfo.a(UsbDeviceInfo.MODEMCtrlPin.MODEM_DTRRTS, n2);
        return 0;
    }

    public int PL2303HXD_SetRTS(int index, boolean state) {
        int n;
        UsbDeviceInfo usbDeviceInfo = null;
        UsbDeviceConnection usbDeviceConnection = null;
        if (this.ad == 0 || index < 0 || this.ad <= index) {
            return -1;
        }
        if (index >= 0) {
            usbDeviceInfo = this.ac[index];
        }
        if (usbDeviceInfo == null || usbDeviceInfo.b() == null) {
            return -2;
        }
        usbDeviceConnection = usbDeviceInfo.g();
        int n2 = usbDeviceInfo.a(UsbDeviceInfo.MODEMCtrlPin.MODEM_DTRRTS);
        if (state && 2 != (n2 & 2)) {
            n2 += 2;
        }
        if (!state && 2 == (n2 & 2)) {
            n2 -= 2;
        }
        if ((n = usbDeviceConnection.controlTransfer(33, 34, n2, 0, null, 0, this.Q)) < 0) {
            return n;
        }
        usbDeviceInfo.a(UsbDeviceInfo.MODEMCtrlPin.MODEM_DTRRTS, n2);
        return 0;
    }

    public int[] PL2303HXD_GetCommModemStatus(int index) {
        int[] nArray = new int[2];
        int n = 0;
        int n2 = 135;
        UsbDeviceInfo usbDeviceInfo = null;
        UsbDeviceConnection usbDeviceConnection = null;
        if (this.ad == 0 || index < 0 || this.ad <= index) {
            nArray[0] = -1;
            return nArray;
        }
        if (index >= 0) {
            usbDeviceInfo = this.ac[index];
        }
        if (usbDeviceInfo == null || usbDeviceInfo.b() == null) {
            nArray[0] = -2;
            return nArray;
        }
        usbDeviceConnection = usbDeviceInfo.g();
        if (usbDeviceConnection == null) {
            nArray[0] = -1;
            return nArray;
        }
        nArray[0] = 0;
        nArray = this.a(usbDeviceConnection, n2);
        if (nArray[0] < 0) {
            return nArray;
        }
        n = (nArray[1] & 1) == 1 ? (n &= 0xFFFFFFF7) : (n |= 8);
        n = (nArray[1] & 2) == 2 ? (n &= 0xFFFFFFFE) : (n |= 1);
        n = (nArray[1] & 4) == 4 ? (n &= 0xFFFFFFFD) : (n |= 2);
        n = (nArray[1] & 8) == 8 ? (n &= 0xFFFFFF7F) : (n |= 0x80);
        nArray[1] = n;
        return nArray;
    }

    static /* synthetic */ int a(PL2303MultiLib pL2303MultiLib, UsbDeviceInfo usbDeviceInfo, byte[] byArray, int n) {
        return pL2303MultiLib.b(usbDeviceInfo, byArray, n);
    }

    static /* synthetic */ int[] b() {
        if (ak != null) {
            return ak;
        }
        int[] nArray = new int[BaudRate.values().length];
        try {
            nArray[BaudRate.B0.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B115200.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B1200.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B1228800.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B14400.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B150.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B1800.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B19200.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B230400.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B2400.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B2457600.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B300.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B3000000.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B38400.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B460800.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B4800.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B57600.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B600.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B6000000.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B614400.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B75.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B921600.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BaudRate.B9600.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        ak = nArray;
        return nArray;
    }

    static /* synthetic */ int[] c() {
        if (al != null) {
            return al;
        }
        int[] nArray = new int[StopBits.values().length];
        try {
            nArray[StopBits.S1.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StopBits.S2.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        al = nArray;
        return nArray;
    }

    static /* synthetic */ int[] d() {
        if (am != null) {
            return am;
        }
        int[] nArray = new int[Parity.values().length];
        try {
            nArray[Parity.EVEN.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parity.NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Parity.ODD.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        am = nArray;
        return nArray;
    }

    static /* synthetic */ int[] e() {
        if (an != null) {
            return an;
        }
        int[] nArray = new int[DataBits.values().length];
        try {
            nArray[DataBits.D5.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataBits.D6.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataBits.D7.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DataBits.D8.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        an = nArray;
        return nArray;
    }

    static /* synthetic */ int[] f() {
        if (ao != null) {
            return ao;
        }
        int[] nArray = new int[FlowControl.values().length];
        try {
            nArray[FlowControl.DTRDSR.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FlowControl.OFF.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FlowControl.RFRCTS.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FlowControl.RTSCTS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FlowControl.RTSCTSDTRDSR.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FlowControl.XONXOFF.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        ao = nArray;
        return nArray;
    }

    public static enum BaudRate {
        B0,
        B75,
        B150,
        B300,
        B600,
        B1200,
        B1800,
        B2400,
        B4800,
        B9600,
        B14400,
        B19200,
        B38400,
        B57600,
        B115200,
        B230400,
        B460800,
        B614400,
        B921600,
        B1228800,
        B2457600,
        B3000000,
        B6000000;

    }

    public static enum DataBits {
        D5,
        D6,
        D7,
        D8;

    }

    public static enum FlowControl {
        OFF,
        RTSCTS,
        RFRCTS,
        DTRDSR,
        RTSCTSDTRDSR,
        XONXOFF;

    }

    class a {
        public ArrayBlockingQueue<Integer> a = new ArrayBlockingQueue(4096, true);
        public Object b = new Object();
        public b c = null;
        public boolean d = false;

        a() {
        }
    }

    public static enum Parity {
        NONE,
        ODD,
        EVEN;

    }

    class b
    extends Thread {
        private int b = 0;
        private int c = 0;
        private boolean d = true;
        private boolean e = false;
        private AtomicInteger f = new AtomicInteger(500);
        private UsbDeviceInfo g = null;
        private a h = null;
        private int i = 0;

        public b(int n, a a2) {
            a2.a.clear();
            if (PL2303MultiLib.this.PL2303IsDeviceConnectedByIndex(n)) {
                this.g = PL2303MultiLib.this.ac[n];
                this.i = n;
                this.h = a2;
            }
        }

        public void a(int n) {
            this.f.set(n);
        }

        public void a() {
            this.e = true;
            while (this.isAlive()) {
            }
            this.h.a.clear();
        }

        private void b(int n) {
            long l;
            if (n == 0) {
                Thread.yield();
                return;
            }
            long l2 = System.currentTimeMillis();
            do {
                l = System.currentTimeMillis();
                Thread.yield();
            } while (l - l2 <= (long)n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            if (!PL2303MultiLib.this.PL2303IsDeviceConnectedByIndex(this.i)) {
                return;
            }
            try {
                var1_1 = new byte[4096];
                while (!this.e) {
                    block12: {
                        this.b = PL2303MultiLib.a(PL2303MultiLib.this, this.g, var1_1, var1_1.length);
                        if (this.b <= 0) break block12;
                        var3_5 = this.h.b;
                        synchronized (var3_5) {
                            this.c = this.h.a.size();
                            if (4096 == this.c) break block12;
                            var4_6 = 0;
                            while (var4_6 < this.b && this.c < 4096) {
                                var2_3 = var1_1[var4_6];
                                if (!this.g.n()) ** GOTO lbl-1000
                                if (19 == var2_3) {
                                    this.g.e(false);
                                } else if (17 == var2_3) {
                                    this.g.e(true);
                                } else lbl-1000:
                                // 2 sources

                                {
                                    this.d = this.h.a.offer(var2_3);
                                    if (!this.d) break;
                                    this.c = this.h.a.size();
                                }
                                ++var4_6;
                            }
                        }
                    }
                    var3_4 = this.f.get();
                    this.b(var3_4);
                }
            }
            catch (Exception var1_2) {
                // empty catch block
            }
        }
    }

    public static enum StopBits {
        S1,
        S2;

    }
}

